<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- ФинансыВерхнееМеню -->
	
	<xsl:template match="/site">
		<div class="container navbar-padding">
			<div class="navbar-header">
				<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
					<span class="sr-only">Toggle navigation</span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<div class="navbar-brand-logo hidden-xs"></div>
				<a class="navbar-brand" href="/">Снаб Лифт</a>
			</div>
			
			<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
				<ul class="nav navbar-nav navbar-right">
					<xsl:apply-templates select="structure[show=1]"/>
				</ul>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template match="structure">
		<!-- Определяем адрес ссылки -->
		<xsl:variable name="link">
			<xsl:choose>
				<!-- Если внешняя ссылка -->
				<xsl:when test="url != ''">
					<xsl:value-of disable-output-escaping="yes" select="url"/>
				</xsl:when>
				<!-- Иначе если внутренняя ссылка -->
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping="yes" select="link"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="current_structure_id" select="/site/current_structure_id"/>
		
		<li>
			<a href="{$link}" class="dropdown-toggle current" role="button" aria-haspopup="true" aria-expanded="false">
				<xsl:attribute name="class"><xsl:text>dropdown-toggle</xsl:text>
					<xsl:if test="$current_structure_id = @id or count(.//structure[@id=$current_structure_id]) = 1">
						<xsl:text> current</xsl:text>
					</xsl:if>
				</xsl:attribute>
				
				<span><xsl:value-of select="name"/></span>
			</a>
		</li>
		
		<!-- <li class="dropdown">
	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><span>Услуги <span class="caret"></span></span></a>
			<ul class="dropdown-menu">
		<li><a href="#"><span>Услуга 1</span></a></li>
				<li role="separator" class="divider"></li>
		<li><a href="#"><span>Услуга 2</span></a></li>
			</ul>
		</li>-->
	</xsl:template>
	
</xsl:stylesheet>