<?php

defined('HOSTCMS') || exit('HostCMS: access denied.');

/**
 * Printlayout_Driver_Model
 *
 * @package HostCMS
 * @subpackage Printlayout
 * @version 6.x
 * @author Hostmake LLC
 * @copyright © 2005-2019 ООО "Хостмэйк" (Hostmake LLC), http://www.hostcms.ru
 */
class Printlayout_Driver_Model extends Core_Entity
{
	/**
	 * Name of the model
	 * @var string
	 */
	protected $_modelName = 'printlayout_driver';

	/**
	 * Default sorting for models
	 * @var array
	 */
	protected $_sorting = array(
		'printlayout_drivers.name' => 'ASC',
	);

	/**
	 * Change driver status
	 * @return self
	 * @hostcms-event printlayout_driver.onBeforeChangeActive
	 * @hostcms-event printlayout_driver.onAfterChangeActive
	 */
	public function changeActive()
	{
		Core_Event::notify($this->_modelName . '.onBeforeChangeActive', $this);

		$this->active = 1 - $this->active;
		$this->save();

		Core_Event::notify($this->_modelName . '.onAfterChangeActive', $this);

		return $this;
	}
	
	
}