<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">

	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- ФинансыПортфолиоНаГлавной -->

	<xsl:template match="/informationsystem">
		<section class="main-home">
			<div class="container">
				<header>
					<h2>Истории успеха наших клиентов</h2>
					<div class="separator-small"></div>
				</header>
			</div>

			<div class="grid">
				<!-- Отображение записи информационной системы -->
				<xsl:apply-templates select="informationsystem_item[active=1]"/>
			</div>
		</section>
	</xsl:template>

	<xsl:template match="informationsystem_item">
		<div class="cell">
			<div class="image-wrapper overlay">
				<img src="{dir}{image_large}" class="responsive-image" />

				<div class="image-overlay-content">
					<h2><xsl:value-of select="name"/></h2>
					<xsl:value-of disable-output-escaping="yes" select="description"/>
					<a href="{url}" class="button"><i class="fa fa-chain"></i></a>
				</div>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>