<?php

defined('HOSTCMS') || exit('HostCMS: access denied.');

/**
 * User_Absence_Model
 *
 * @package HostCMS
 * @subpackage User
 * @version 6.x
 * @author Hostmake LLC
 * @copyright © 2005-2019 ООО "Хостмэйк" (Hostmake LLC), http://www.hostcms.ru
 */
class User_Absence_Model extends Core_Entity
{
	/**
	 * Model name
	 * @var mixed
	 */
	protected $_modelName = 'user_absence';

	/**
	 * Belongs to relations
	 * @var array
	 */
	protected $_belongsTo = array(
		'user' => array(),
		'user_absence_type' => array(),
		'employee' => array('foreign_key' => 'employee_id', 'model' => 'user')
	);

	/**
	 * Default sorting for models
	 * @var array
	 */
	protected $_sorting = array(
		'user_absences.id' => 'ASC',
	);

	/**
	 * Constructor.
	 * @param int $id entity ID
	 */
	public function __construct($id = NULL)
	{
		parent::__construct($id);

		if (is_null($id) && !$this->loaded())
		{
			$oUser = Core_Auth::getCurrentUser();
			$this->_preloadValues['user_id'] = is_null($oUser) ? 0 : $oUser->id;
			$this->_preloadValues['datetime'] = Core_Date::timestamp2sql(time());
		}
	}

	/**
	 * Backend callback method
	 * @param Admin_Form_Field $oAdmin_Form_Field
	 * @param Admin_Form_Controller $oAdmin_Form_Controller
	 * @return string
	 */
	public function employee_idBackend($oAdmin_Form_Field, $oAdmin_Form_Controller)
	{
		ob_start();

		$this->Employee->id && $this->Employee->showAvatarWithName();

		return ob_get_clean();
	}

	/**
	 * Backend callback method
	 * @param Admin_Form_Field $oAdmin_Form_Field
	 * @param Admin_Form_Controller $oAdmin_Form_Controller
	 * @return string
	 */
	public function user_absence_type_idBackend($oAdmin_Form_Field, $oAdmin_Form_Controller)
	{
		return $this->user_absence_type_id
			? $this->User_Absence_Type->getTypeAbbrHtml()
			: '';
	}

	/**
	 * Check user access to admin form action
	 * @param User_Model $oUser user object
	 * @param string $actionName admin form action name
	 * @return bool
	 */
	public function checkBackendAccess($actionName, $oUser)
	{
		return $oUser->isHeadOfEmployee($this->Employee);
	}
}