<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">

	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- ФинансыУслугиНаГлавной -->

	<xsl:template match="/informationsystem">
		<section class="main-services">
			<div class="container">
				<div class="row">
					<!-- Отображение записи информационной системы -->
					<xsl:apply-templates select="informationsystem_item[active=1]"/>
				</div>
				<a href="{url}" class="btn btn-lightred">Все услуги</a>
			</div>
		</section>
	</xsl:template>

	<xsl:template match="informationsystem_item">
		<div class="main-services-item col-xs-12 col-md-4">
			<div class="main-services-image">
				<i class="{property_value[tag_name = 'icon']/value}"></i>
			</div>
			<div class="main-services-name">
				<h4><a href="{url}"><xsl:value-of select="name"/></a></h4>
			</div>
			<div class="main-services-text">
				<xsl:value-of disable-output-escaping="yes" select="description"/>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>