<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- СписокНовостейНаГлавной -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/informationsystem"/>
	</xsl:template>
	
	<xsl:template match="/informationsystem">
		<!-- Выводим название информационной системы -->
		<!--<h3 hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</h3>-->
		
		<h1 class="uk-margin-large-bottom uk-text-center uk-text-bold" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</h1>
		
		<!-- Отображение записи информационной системы -->
		<xsl:if test="informationsystem_item">
			<div uk-slider="autoplay: true;autoplay-interval:4000">
				
				<div class="uk-position-relative">
					
					<div class="uk-slider-container uk-light">
						<ul class="uk-slider-items uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m">
							
							<xsl:apply-templates select="informationsystem_item"/>
						</ul>
					</div>
					
					<div class="uk-hidden@s uk-light">
						<a class="uk-position-center-left uk-position-small" href="#" uk-slidenav-previous="" uk-slider-item="previous"></a>
						<a class="uk-position-center-right uk-position-small" href="#" uk-slidenav-next="" uk-slider-item="next"></a>
					</div>
					
					<div class="uk-visible@s">
						<a class="uk-position-center-left-out uk-position-small" href="#" uk-slidenav-previous="" uk-slider-item="previous"></a>
						<a class="uk-position-center-right-out uk-position-small" href="#" uk-slidenav-next="" uk-slider-item="next"></a>
					</div>
					
				</div>
				
				<ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>
				
			</div>
		</xsl:if>
		
	<!--<p><a class="uk-button uk-button-primary" href="{url}" title="Все новости">Все <xsl:value-of disable-output-escaping="yes" select="name"/></a></p>-->
	</xsl:template>
	
	<!-- Шаблон вывода информационного элемента -->
	<xsl:template match="informationsystem_item">
		
		<li>
			<div class="uk-flex uk-flex-center uk-flex-middle uk-card uk-card-default uk-card-body uk-height-medium">
				<img src="{dir}{image_small}" alt=""  />
			</div>
		</li>
		
		
		
		
	</xsl:template>
	
	
	
	
	
	
	<!-- Вывод даты с месяцем на русском -->
	<xsl:template name="date_to_str">
		<xsl:param name="date" select="date"/>
		
		<xsl:variable select="substring-after($date, '.')" name="month_postfixDate" />
		<xsl:variable select="substring-before($month_postfixDate, '.')" name="month" />
		
		<xsl:value-of select="substring-before($date, '.')"/>&#160;<xsl:choose>
			<xsl:when test="$month = 1">января</xsl:when>
			<xsl:when test="$month = 2">февраля</xsl:when>
			<xsl:when test="$month = 3">марта</xsl:when>
			<xsl:when test="$month = 4">апреля</xsl:when>
			<xsl:when test="$month = 5">мая</xsl:when>
			<xsl:when test="$month = 6">июня</xsl:when>
			<xsl:when test="$month = 7">июля</xsl:when>
			<xsl:when test="$month = 8">августа</xsl:when>
			<xsl:when test="$month = 9">сентября</xsl:when>
			<xsl:when test="$month = 10">октября</xsl:when>
			<xsl:when test="$month = 11">ноября</xsl:when>
			<xsl:otherwise>декабря</xsl:otherwise>
		</xsl:choose>&#160;<xsl:value-of select="substring-after($month_postfixDate, '.')"/>
	</xsl:template>
</xsl:stylesheet>